#version 330
#extension GL_EXT_gpu_shader4 : enable
// Mandelbrot AntennaMod01.fsh  by  arthurstammet

//https://www.shadertoy.com/view/wdXXDn
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.0177  //*0.1666
#define iResolution u_WindowSize

#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Mandelbrot Antenna Explorer
// Based on https://www.youtube.com/watch?v=6IWXkV82oyY
// Zoom into the Antenna-Animation with the Mouse and watch the animation
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 m = iMouse.xy / iResolution.xy;
    float zoom = pow(25., -m.x*3.);    
    float speed = m.y / iResolution.y;
    
    vec2 uv = (gl_FragCoord.xy-.5*iResolution.xy) / iResolution.y;
    uv = uv*2.;
    vec2 c = uv*zoom;
    c += vec2(-1.5 + (sin(iTime*speed)*.3), 0.); // animated x-position

    vec2 z = vec2(0.);
    float iter = 0.;

    const float max_iter = 75.;

    for(float i=0.; i<max_iter; i++) {
        // z = z^2 + c
        z = vec2(z.x*z.x - z.y*z.y, 2.*z.x*z.y) + c;
        // ma = min(ma, abs(z.x));
        if(length(z)>2.) break;
        iter++;
    }
    float f = iter/max_iter;
    vec3 col = texture2D(iChannel0, vec2(f, .5+(sin(iTime*.005)*.48))).rgb;
    gl_FragColor = vec4(col,1.);
}